/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xcidefs.h 
 *       Type Definitions for Completer-Initiator (CI) Functions
 * -----------------------------------------------------------------*/

#ifndef XCIDEFS_H_INCLUDED                               
#define XCIDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif

/********************************************************************
  CI generics *******************************************************
 *******************************************************************/

#define BX_CIGENPROP_SIZE   19

CLI typedef enum {
  BX_CIGEN_NUMBEH,        /* @numbeh   */
  BX_CIGEN_NUMBEHG0,      /* @numbehg0 */
  BX_CIGEN_NUMBEHG1,      /* @numbehg1 */
  BX_CIGEN_NUMBEHG2,      /* @numbehg2 */
  BX_CIGEN_NUMBEHG3,      /* @numbehg3 */
  BX_CIGEN_NUMBEHG4,      /* @numbehg4 */
  BX_CIGEN_NUMBEHG5,      /* @numbehg5 */
  BX_CIGEN_NUMBEHG6,      /* @numbehg6 */
  BX_CIGEN_NUMBEHG7,      /* @numbehg7 */
  BX_CIGEN_NUMBEHG8,      /* @numbehg8 */
  BX_CIGEN_MESSAGE_AD,    /* @mesad    */
  BX_CIGEN_ADDR7,         /* @addr7    */
  BX_CIGEN_ADDR30,        /* @addr30   */
  BX_CIGEN_ADDR31,        /* @addr31   */
  BX_CIGEN_ATTR24,        /* @attr24   */
  BX_CIGEN_ATTR25,        /* @attr25   */
  BX_CIGEN_ATTR26,        /* @attr26   */
  BX_CIGEN_ATTR27,        /* @attr27   */
  BX_CIGEN_ATTR28         /* @attr28   */
} bx_cigentype;

/********************************************************************
  CI behavior *******************************************************
 *******************************************************************/

CLI typedef enum {
  BX_CIBEH_QUEUE,      /* @queue     */ /* Group 2 */
  BX_CIBEH_ADDR7,      /* @addr7     */ /* Group 2 */
  BX_CIBEH_ADDR30,     /* @addr30    */ /* Group 2 */
  BX_CIBEH_ADDR31,     /* @addr31    */ /* Group 2 */
  BX_CIBEH_ATTR24,     /* @attr24    */ /* Group 2 */
  BX_CIBEH_ATTR25,     /* @attr25    */ /* Group 2 */
  BX_CIBEH_ATTR26,     /* @attr26    */ /* Group 2 */
  BX_CIBEH_ATTR27,     /* @attr27    */ /* Group 3 */
  BX_CIBEH_ATTR28,     /* @attr28    */ /* Group 3 */
  BX_CIBEH_ERRMESSAGE, /* @errmessage*/ /* Group 3 */
  BX_CIBEH_PARTITION,  /* @partition */ /* Group 1 */
  BX_CIBEH_CONDSTART,  /* @condstart */ /* Group 3 */
  BX_CIBEH_DELAY,      /* @delay     */ /* Group 1 */
  BX_CIBEH_STEPS,      /* @steps     */ /* Group 2 */
  BX_CIBEH_REQ64,      /* @req64     */ /* Group 2 */
  BX_CIBEH_RELREQ,     /* @relreq    */ /* Group 1 */
  BX_CIBEH_REPEAT,     /* @repeat    */ /* Group 0 */
  BX_CIBEH_ENUMSIZE    /* $enumsize */
} bx_cibehtype;

#define BX_CIBEHPROP_SIZE  ((bx_int32) BX_CIBEH_ENUMSIZE)

/* Attention: The definition for 
BX_CIBEH_QUEUE_AUTO is 'qAuto'
BX_RIBLK_QUEUE_AUTO is 'qAuto' too
*/
CLI  /* DEF_START ~G_BX_CIBEH_QUEUE */
#define BX_CIBEH_QUEUE_NEXT  1   /* @Next */
#define BX_CIBEH_QUEUE_NONE  2   /* @None */
#define BX_CIBEH_QUEUE_AUTO  3   /* @qauto */
#define BX_CIBEH_QUEUE_ASKIP 4   /* @ASkip */
#define BX_CIBEH_QUEUE_BSKIP 5   /* @BSkip */
#define BX_CIBEH_QUEUE_CSKIP 6   /* @CSkip */
#define BX_CIBEH_QUEUE_DSKIP 7   /* @DSkip */
#define BX_CIBEH_QUEUE_AWAIT 8   /* @AWait */
#define BX_CIBEH_QUEUE_BWAIT 9   /* @BWait */
#define BX_CIBEH_QUEUE_CWAIT 0xa  /* @CWait */
#define BX_CIBEH_QUEUE_DWAIT 0xb  /* @DWait */
CLI  /* DEF_END */


CLI  /* DEF_START ~G_BX_CIBEH_PARTITION */
#define BX_CIBEH_PARTITION_NO    0   /* @No */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_CIBEH_CONDSTART */
#define BX_CIBEH_CONDSTART_NO      0   /* @No    */
#define BX_CIBEH_CONDSTART_ONCE1   2   /* @Once1 */
#define BX_CIBEH_CONDSTART_ONCE2   4   /* @Once2 */
#define BX_CIBEH_CONDSTART_WAIT1   3   /* @Wait1 */
#define BX_CIBEH_CONDSTART_WAIT2   5   /* @Wait2 */
CLI  /* DEF_END */

/********************************************************************
  CI behavior groups *****************************************
 *******************************************************************/

CLI typedef enum {
  BX_CIBEHGRP_0 = 1UL << 0UL, /* @cibehgrp0 */
  BX_CIBEHGRP_1 = 1UL << 1UL, /* @cibehgrp1 */
  BX_CIBEHGRP_2 = 1UL << 2UL, /* @cibehgrp2 */
  BX_CIBEHGRP_3 = 1UL << 3UL, /* @cibehgrp3 */
  BX_CIBEHGRP_4 = 1UL << 4UL, /* @cibehgrp4 */
  BX_CIBEHGRP_5 = 1UL << 5UL, /* @cibehgrp5 */
  BX_CIBEHGRP_6 = 1UL << 6UL, /* @cibehgrp6 */
  BX_CIBEHGRP_7 = 1UL << 7UL, /* @cibehgrp7 */
  BX_CIBEHGRP_8 = 1UL << 8UL, /* @cibehgrp8 */
  BX_CIBEHGRP_ENUMSIZE        /* $enumsize  */
} bx_cibehgrptype;

#define BX_CIBEHGRP_SIZE BX_CIBEHGRP_ENUMSIZE

#endif
